%------------------------------------------------------------------------------
% File     : LCL861^1 : TPTP v7.4.0. Bugfixed v5.0.0.
% Domain   : Logical Calculi (Modal logic)
% Problem  : Modal logic S5(=M5) coincides with M45
% Version  : [Ben10] axioms.
% English  : 

% Refs     : [Ben10a] Benzmueller (2010), Email to Geoff Sutcliffe
%          : [Ben10b] Benzmueller (2010), Simple Type Theory as a Framework
% Source   : [Ben10a]
% Names    : Problem 23 [Ben10b]

% Status   : Theorem
% Rating   : 0.00 v6.1.0, 0.14 v5.5.0, 0.17 v5.4.0, 0.20 v5.3.0, 0.40 v5.2.0, 0.20 v5.0.0
% Syntax   : Number of formulae    :   64 (   0 unit;  32 type;  31 defn)
%            Number of atoms       :  232 (  36 equality; 135 variable)
%            Maximal formula depth :   11 (   6 average)
%            Number of connectives :  132 (   4   ~;   4   |;  11   &; 104   @)
%                                         (   1 <=>;   8  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :  170 ( 170   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   36 (  32   :;   0   =)
%            Number of variables   :   85 (   3 sgn;  30   !;   6   ?;  49   ^)
%                                         (  85   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
% Bugfixes : v5.0.0 - Bugfix to LCL013^0.ax
%------------------------------------------------------------------------------
%----Include the definitions for quantified multimodal logic
include('Axioms/LCL013^0.ax').
%------------------------------------------------------------------------------
thf(conj,conjecture,(
    ! [R: $i > $i > $o] :
      ( ( ( mreflexive @ R )
        & ( meuclidean @ R ) )
    <=> ( ( mreflexive @ R )
        & ( mtransitive @ R )
        & ( meuclidean @ R ) ) ) )).

%------------------------------------------------------------------------------
